package furny.swing.admin.tags;

import java.awt.datatransfer.Transferable;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.TransferHandler;

import furny.entities.Tag;

/**
 * {@link TransferHandler} for tags. (for drag and drop)
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
@SuppressWarnings("serial")
public class TagTransferHandler extends TransferHandler {
  private final TagTree tree;

  /**
   * Instantiates a new tag transfer handler.
   * 
   * @param tree
   *          the tree
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public TagTransferHandler(final TagTree tree) {
    this.tree = tree;
  }

  @Override
  protected Transferable createTransferable(final JComponent component) {
    final List<Tag> selection = tree.getSelectedTags();
    if (!selection.isEmpty()) {
      return new TagTransferable(selection);
    } else {
      return null;
    }
  }

  @Override
  public int getSourceActions(final JComponent c) {
    return COPY;
  }
}
